cog_x = 0.0
cog_y = 1.46238
cog_z = 0.0

dofile(current_mod_path .. "/default_radio_presets.lua")
local radio_presets = get_default_radio_presets()


local removed_front_doors = {
		{station = 6,loadout = {"<CLEAN>"}},    
	}


local removed_doors = {
		{station = 6,loadout = {"<CLEAN>"}},  
		{station = 7,loadout = {"<CLEAN>"}},  
	}
	
	
local removed_back_doors = {
		{station = 7,loadout = {"<CLEAN>"}},      
	}	
	
	

OH6 = {
	Name                     = 'OH-6A',
	Picture                  = 'OH-6.png', -- Mission editor loadout picture
	DisplayName              = _('OH-6A'),

	shape_table_data         = {
		{
			file     = 'OH-6A',
			username = 'OH-6A',
			desrt    = 'OH-6A',
			index    = WSTYPE_PLACEHOLDER,
			life     = 6, --   The strength of the object (ie. lifebar *)
			vis      = 3,  -- Visibility factor (For a small objects is better to put lower nr).
			fire     = { 300, 2 }, -- Fire on the ground after destoyed: 300sec 4m
			--classname   = "lLandPlane";
			--positioning = "BYNORMAL";
		},
		{
			name = "OH-6A",
			file = "OH-6A",
			fire = { 240, 2 },
		},
	},

	mapclasskey              = "P0091000021", 
	attribute                = { wsType_Air, wsType_Helicopter, wsType_Battleplane, WSTYPE_PLACEHOLDER,
		"Attack helicopters", },
	Categories               = {"Helicopter",},
	Rate                     = 30, -- RewardPoint in Multiplayer
	Countries                = { "USA" },
	-------------- Aircraft Physical properties -----------
	length                   = 10.0, -- meters
	height                   = 3.0, -- meters
	rotor_RPM                = 470,
	M_empty                  = 897, --998, --kg 897-40 for doors
	M_nominal                = 1089, --kg
	M_max                    = 1225, --kg		
	M_fuel_max               = 181, -- kg	

	average_fuel_consumption = 0.3,
	tanker_type              = 0,
	RCS                      = 3, -- Radar Cross Section m^2
	IR_emission_coeff        = 0.3, -- 1 is IR emission of Su-27

	------------------ AI defs ------------------------------
	V_max                    = 217.0, -- m/s max speed for AI
	V_max_cruise             = 210, -- cruise speed
	Vy_max                   = 10.5, --Max climb speed in m/s
	H_stat_max_L             = 5070,
	H_max                    = 5500, --km, max operation height
	H_stat_max               = 3040,
	H_din_two_eng            = 5500,
	H_din_one_eng            = 5500,
	range                    = 330, --km, for AI
	flight_time_typical      = 90,
	flight_time_maximum      = 189,
	Vy_land_max              = 10.0, -- landing speed
	Ny_max                   = 3.5, --max G for AI
	Sensors                  = {-- defines what the AI can use in terms of sensors
		RWR = "Abstract RWR"
	},
	--CanopyGeometry = makeHelicopterCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
	CanopyGeometry           = {
		azimuth   = { -100.0, 120.0 },  -- pilot view horizontal (AI)
		elevation = { -50.0, 110.0 }    -- pilot view vertical (AI)
	},
	-------------------------------------------------------------------		
	nose_gear_pos            = { -0.423371 + cog_x, -0.504654 - 0 * cog_y, 0.0 }, -- used for starting placement on ground {forward/back,up/down,left/right}
	main_gear_pos            = { 1.61942 + cog_x, -0.619909 - 0 * cog_y, 1.0 },
	---------------------- unknown
	---------------------- unknown ---------------------------------------------
	lead_stock_main          = -0.1,
	lead_stock_support       = -0.1,
	scheme                   = 0,
	fire_rate                = 0,
	cannon_sight_type        = 2,
	------------ AI flight model probably (doesnt affect human FM)---------------
	rotor_height             = 2.7, -- meters
	rotor_diameter           = 8.33, --8.33, --m
	blade_chord              = 0.171,
	blades_number            = 4,
	blade_area               = 0.7, --m^2
	fuselage_Cxa0            = 0.4,
	fuselage_Cxa90           = 3,
	fuselage_area            = 1.4,
	centering                = 0,
	tail_pos                 = { 1.61942 + cog_x, -0.619909 - 0 * cog_y, -1.0},
	tail_fin_area            = 0.467,
	tail_stab_area           = 0.66,
	thrust_correction        = 0.55,
	rotor_MOI                = 1500,
	rotor_pos                = { 0, 0.84, 0 },
	sounderName = "Aircraft/Planes/OH6",
	sound_name               = "External/oh6_Silent",
	helicopter_hook_pos      = { 0, -1, 0 },

	engines_count            = 2,
	engines_nozzles          =
	{
		{
			pos             = { -1.87641, 0.790134, 0.0 }, -- important for heatblur effect -- important for heatblur effect
			diameter        = 0.13,
			engine_number   = 1,
			smokiness_level = 0.01,
		},
	},

	crew_size                = 2,
	crew_members             =
	{
		[1] =
		{ 	
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
			pos                = { 1.3, 1.0, 1.5 },   
			ejection_order     = 1,
			can_be_playable    = true,
			role               = "pilot",
			role_display_name  = _("Pilot"),
			canopy_arg           = 38,
		},
		[2] =
		{ 
			ejection_seat_name	=	0,
			drop_canopy_name	=	0,
			pos                = { 1.3, 1.0, - 1.5 },
			ejection_order     = 2,
			can_be_playable    = true,
			role               = "instructor",
			role_display_name  = _("Instructor pilot"),
			canopy_arg           = 38,
		},
	},

	fires_pos                =
	{
		[1] = { -1.87641, 0.790134, 0.0 }, -- turbine exit
	},

	Guns = {
		
	},
	
	Pylons = {
		pylon(1, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G4",arg = 133, arg_value = 0 },
		{
			{CLSID = "{OH6_SMOKE_RED}",    arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_GREEN}",  arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_BLUE}",   arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_YELLOW}", arg_value = 1.0,required = removed_front_doors},
			}
		),
		pylon(2, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G3",arg = 132, arg_value = 0 },
		{
			{CLSID = "{OH6_SMOKE_RED}",    arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_GREEN}",  arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_BLUE}",   arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_YELLOW}", arg_value = 1.0,required = removed_front_doors},		
		}
		),
		pylon(3, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G2",arg = 131, arg_value = 0 },
		{
			{CLSID = "{OH6_SMOKE_RED}",    arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_GREEN}",  arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_BLUE}",   arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_YELLOW}", arg_value = 1.0,required = removed_front_doors},
		}
		),
		pylon(4, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G1",arg = 130, arg_value = 0 },
		{
			{CLSID = "{OH6_SMOKE_RED}",    arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_GREEN}",  arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_BLUE}",   arg_value = 1.0,required = removed_front_doors},
			{CLSID = "{OH6_SMOKE_YELLOW}", arg_value = 1.0,required = removed_front_doors},
		}
		),
		pylon(5, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "HE",arg = 135, arg_value = 0 },
		{
			{ CLSID = "{OH6_FRAG}", arg_value = 1.0,required = removed_front_doors},
		}
		),    
		pylon(6, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, connector = "FDoors", DisplayName = "F.Doors", arg = 209, arg_value = 0 },
			{
				{ CLSID = "<CLEAN>", arg_value = 1.0, add_mass = -10 },
			}
		),
		pylon(7, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = false, connector = "RDoors", DisplayName = "R.Doors", arg = 210, arg_value = 0 },
			{
				{ CLSID = "<CLEAN>", arg_value = 1.0, add_mass = -10 },
			}
		),
		pylon(8, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = true, connector = "Gun_Attach", attach_point_oriented = true,
				DisplayName = "Gun", arg = 111, arg_value = 0 },
			{
				{ CLSID = "{OH-6_M134_Minigun1}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun2}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun3}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun4}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun5}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun6}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun7}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun8}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun9}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun10}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun11}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun12}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun13}", arg_value = 1.0, attach_point_oriented = true},   

				{ CLSID = "{OH-6_M134_Minigun14}", arg_value = 1.0, attach_point_oriented = true},   


 			{CLSID = "{OH6_Browning_M3P_1}", arg_value = 0, attach_point_position = {-0.11, 0.05 , -0.39 }},                                

 			{CLSID = "{OH6_Browning_M3P_2}", arg_value = 0, attach_point_position = {-0.11, 0.05 , -0.39 }},                                 

 			{CLSID = "{OH6_Browning_M3P_3}", arg_value = 0, attach_point_position = {-0.11, 0.05 , -0.39 }},                                  

 			{CLSID = "{OH6_GIAT_M261_1}", arg_value = 0, attach_point_position = {-0.0, 0.00 , -0.0 }},                                
 			
			{CLSID = "{OH6_GIAT_M261_2}", arg_value = 0, attach_point_position = {-0.0, 0.00 , -0.0 }},                                 

			{CLSID = "{OH6_GIAT_M261_3}", arg_value = 0, attach_point_position = {-0.0, 0.00 , -0.0 }},       

			{CLSID = "{OH-6_M129}", arg_value = 0.0, attach_point_oriented = true, required = removed_back_doors, } --ANDR0ID Added			

			}       
		), 
		pylon(9, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)   
			{ use_full_connector_position = true, connector = "Pylon1", attach_point_oriented = true,  
				DisplayName = "R L",arg = 117,arg_value = 0.0,},
			{
				{CLSID = "{OH6_XM158}", arg_value = 1.0},

				{CLSID = "{OH6_XM158_4}", arg_value = 1.0},
				
				
			{CLSID = "XM158_M257", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }}, 
	
			{CLSID = "XM158_M156", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }},  

			{CLSID = "XM158_MK5", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }},  

			{CLSID = "XM158_M274", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }},
		
			{CLSID = "XM158_MK1", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }},
				
			{CLSID = "XM158_M151", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0 }},					
			



			{CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},	
			
			{CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
  	
			{CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
 
			{CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
 
			{CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
 
			{CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
			
			{CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
 
			{CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},   

			{CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
 
			{CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},

			{CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},  

			{CLSID = "OH_6_FIM_92_L", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , -0.1 }},    
   				
			{CLSID = "OH6_AGM_114K_L", arg_value = 1.0, attach_point_position = {0.1, 0.05 , -0.15 }},                     

			{CLSID = "OH6_AGM_114K_L1", arg_value = 1.0, attach_point_position = {0.1, 0.05 , -0.15 }},                     

			{CLSID = "{LAU-131 - 7 AGR-20 M282}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},                  

 			{CLSID = "{LAU-131 - 7 AGR-20A}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},                 

 			{CLSID = "{M260_APKWS_M151}", arg_value = 1.0, attach_point_position = {-0.0, -0.11 , 0.0 }},                  

 			{CLSID = "OH6_AGM_114_L", arg_value = 1.0, attach_point_position = {0.1, 0.05 , -0.15 }},                   

 			{CLSID = "OH6_AGM_114_L1", arg_value = 1.0, attach_point_position = {0.1, 0.05 , -0.15 }},                   

 			--{CLSID = "{OH6_Browning_M3P_1}", arg_value = 1.0, attach_point_position = {-0.11, 0.2 , -0.01 }},                             

 			--{CLSID = "{OH6_Browning_M3P_2}", arg_value = 1.0, attach_point_position = {-0.11, 0.2 , -0.01 }},                              

 			--{CLSID = "{OH6_Browning_M3P_3}", arg_value = 1.0, attach_point_position = {-0.11, 0.2 , -0.01 }},                              
				
 			{CLSID = "{OH6_FN_HMP_1}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , -0.13}},                                

 			{CLSID = "{OH6_FN_HMP_2}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , -0.13}},                                

 			{CLSID = "{OH6_FN_HMP_3}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , -0.13}},                                
		
			}                     
		),
		pylon(10, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = true, connector = "Pylon2", attach_point_oriented = true,
				DisplayName = "R R",arg = 118,arg_value = 0.0,},
			{
				{CLSID = "{OH6_XM158}", arg_value = 1.0,},
				
				{CLSID = "{OH6_XM158_4}", arg_value = 1.0,},
				
				
				
				{CLSID = "XM158_M257", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}},		
				
				{CLSID = "XM158_M156", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}}, 
				
				{CLSID = "XM158_MK5", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}}, 
				
				{CLSID = "XM158_M274", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}}, 
				
				{CLSID = "XM158_MK1", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}}, 
				
				{CLSID = "XM158_M151", arg_value = 1.0, attach_point_position = {0.01, 0.01 , 0.0}}, 



				{CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 

				{CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 

				{CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 
				
				{CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},
				
				{CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }}, 

				{CLSID = "OH_6_FIM_92_R", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.04 }},          
  
				{CLSID = "OH6_AGM_114K_R", arg_value = 1.0, attach_point_position = {0.1, 0.05 , 0.15 }},                

				{CLSID = "OH6_AGM_114K_R1", arg_value = 1.0, attach_point_position = {0.1, 0.05 , 0.15 }},                

				{CLSID = "{LAU-131 - 7 AGR-20 M282}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},                

				{CLSID = "{LAU-131 - 7 AGR-20A}", arg_value = 1.0, attach_point_position = {-0.08, -0.11 , 0.0 }},                

				{CLSID = "{M260_APKWS_M151}", arg_value = 1.0, attach_point_position = {-0.0, -0.11 , 0.0 }},                

				{CLSID = "OH6_AGM_114_R", arg_value = 1.0, attach_point_position = {0.1, 0.05 , 0.15 }},                    
	
				{CLSID = "OH6_AGM_114_R1", arg_value = 1.0, attach_point_position = {0.1, 0.05 , 0.15 }},                    

				{CLSID = "{OH6_FN_HMP_1}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , 0.13}},                                 

				{CLSID = "{OH6_FN_HMP_2}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , 0.13}},                                 

				{CLSID = "{OH6_FN_HMP_3}", arg_value = 1.0, attach_point_position = {-0.1, 0.15 , 0.13}},                                  
		
			}             
		),
		
		pylon(11, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = true, connector = "Door_Gun_Attach", attach_point_oriented = true,
				DisplayName = "DoorGun", arg = 113, arg_value = 0 },
			{
				{ CLSID = "{OH-6_M60_Door}", arg_value = 0.5, attach_point_oriented = true, required = removed_back_doors},
				{ CLSID = "{OH-6_M134_Door}", arg_value = 1.0, attach_point_oriented = true, required = removed_back_doors},
				
			}
		),

		pylon(12, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ 
				DisplayName = "Xtra", arg = 140, arg_value = 0.0 },
				{
					{ CLSID = "{OH-6_CAMRIG}", arg_value = 0.55, attach_point_oriented = false}, 
					
					{ CLSID = "{OH-6_CAMMAN}", arg_value = 0.4, attach_point_oriented = false, required = removed_back_doors}, 
					
					{ CLSID = "{OH-6_Searchlight}", arg_value = 1.0, attach_point_oriented = false},   
					
					{ CLSID = "{OH-6_FLOATERS}", arg_value = -1.0, attach_point_oriented = false},  			
				}
		),
		
		pylon(13, 0, 0.0, 0.7, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ 
				DisplayName = "Cargo", arg = 211, arg_value = 0.0 },
				{
					{ CLSID = "{OH-6_CARGO_AMMO}", arg_value = 1.0, attach_point_oriented = false,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_CRATES}", arg_value = 0.0, attach_point_oriented = false,required = removed_back_doors,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_PAX}", arg_value = 0.0, attach_point_oriented = false,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_ANIMAL}", arg_value = 1.0, attach_point_oriented = false,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_PIGS}", arg_value = 1.0, attach_point_oriented = false,required = removed_back_doors,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_SOLDIERS}", arg_value = 1.0, attach_point_oriented = false,required = removed_doors,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_CANS}", arg_value = 1.0, attach_point_oriented = false,
					forbidden = cargo_restrictions},
					{ CLSID = "{OH-6_CARGO_OPERATOR}", arg_value = 1.0, attach_point_oriented = false,required = removed_back_doors,},			
				
				 { CLSID = "{#_Fuel1}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },      
				 { CLSID = "{#_Fuel2}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },      
				 { CLSID = "{#_Fuel3}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },               				 
				 { CLSID = "{#_Fuel4}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },               				 
				 { CLSID = "{#_Fuel5}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },                   				 
				 { CLSID = "{#_Fuel6}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },                       				 

				  		 		  
				 { CLSID = "{#_Fuel9}", arg_value = 0.0, attach_point_position = {-0.1, -0.36 , 0 }, Rotation = {-0,0,0}, }, 
						
 
				 { CLSID = "{#_Passenger1}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, required  = {{station = 7,loadout = {"<CLEAN>"}}, },  },                 				 					        
				 { CLSID = "{#_Passenger2}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, required  = {{station = 7,loadout = {"<CLEAN>"}}, },  },                          				 					               
				 { CLSID = "{#_Passenger3}", arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, required  = {{station = 7,loadout = {"<CLEAN>"}}, },  },                 				 					

				 { CLSID = "{#_Barrel1}",  arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },       				
				 { CLSID = "{#_Barrel4}",  arg_value = 0.0, attach_point_position = {-0.1, -0.36 , 0 }, Rotation = {-0,0,0}, },       				 					
				 { CLSID = "{#_Barrel5}",  arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },       				 					
  				
				 { CLSID = "{#_Ammo1}", arg_value = 0.0, attach_point_position = {-0.1, -0.36 , 0 }, Rotation = {-0,0,0}, },         
				 { CLSID = "{#_Ammo2}", arg_value = 0.0, attach_point_position = {-0.1, -0.36 , 0 }, Rotation = {-0,0,0}, },       

				 { CLSID = "{#_Beer}",  arg_value = 0.0, attach_point_position = {-0.0, -0.7 , 0 }, Rotation = {-0,0,0}, },       				 					



				}                           
		),




		pylon(14, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ 
				DisplayName = "Sprayer", arg =173 , arg_value = 0.0 },   
				{ 

				 { CLSID = "{SPRAYER_P}", arg_value = 0.0, attach_point_position = {-1.0, 1.0, 0},
					required = 
					 {
						{station = 15, loadout = {"{SPRAY_P}"} },
						{station = 16, loadout = {"{SPRAY_P}"} },
					
					 },
				 },	
				 
				 { CLSID = "{SPRAYER_F}", arg_value = 0.0, attach_point_position = {-1.0, 1.0, 0},
					required = 
					 {
						{station = 15, loadout = {"{SPRAY_F}"} }, 
						{station = 16, loadout = {"{SPRAY_F}"} },  
				
					 },
				 },	
				 
				 { CLSID = "{SPRAYER_H}", arg_value = 0.0, attach_point_position = {-1.0, 1.0, 0},
					required = 
					 {
						{station = 15, loadout = {"{SPRAY_H}"} }, 
						{station = 16, loadout = {"{SPRAY_H}"} },   
				
					 },
				 },
				 
				}                     
		),


		pylon(15, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ 
				DisplayName = "Spray", arg =174 , arg_value = 0.0 },                
				{ 
					
					{ CLSID = "{SPRAY_P}", attach_point_position = {0, 0, 5}, },
					{ CLSID = "{SPRAY_F}", attach_point_position = {0, 0, 5}, },
					{ CLSID = "{SPRAY_H}", attach_point_position = {0, 0, 5}, },
					
				}                   
		),		

		pylon(16, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ 
				DisplayName = "Spray", arg =175 , arg_value = 0.0 },                
				{ 
					
					{ CLSID = "{SPRAY_P}", attach_point_position = {0, 0, -5}, }, 
					{ CLSID = "{SPRAY_F}", attach_point_position = {0, 0, -5}, },				
					{ CLSID = "{SPRAY_H}", attach_point_position = {0, 0, -5}, },
					
				}                   
		),		


	},

	Tasks = {                     -- defined in db_units_planes.lua
		aircraft_task(Transport), --31
		aircraft_task(Reconnaissance),
	},
	DefaultTask = aircraft_task(Reconnaissance), 
	

	passivCounterm =
	{
		CMDS_Edit = true,
		SingleChargeTotal = 30,
		flare = {default = 30, increment = 30, chargeSz = 1},
		chaff = {default = 0, increment = 30, chargeSz = 1},
	},

    chaff_flare_dispenser =
	{
		--{ dir =  {Z, Y, X}, pos =  {Z, Y, X}, }  -- Z=back/fwd,Y=down/up, X=left/right
        [1] = { dir =  {0.956935,-0.2903036,0}, pos =  {0.050, -0.216716, 0}, }, 
    },


	LandRWCategories = -- adds these takeoff and landing options avaliable in mission editor
	{
		[1] =
		{
			Name = "HelicopterCarrier",
		},
		[2] =
		{
			Name = "AircraftCarrier",
		},
	},
	TakeOffRWCategories =
	{
		[1] =
		{
			Name = "HelicopterCarrier",
		},
		[2] =
		{
			Name = "AircraftCarrier",
		},
	},

	Damage = verbose_to_dmg_properties(                                   --index meaning see in Scripts\Aircrafts\_Common\Damage.lua
		{
		                                                                  -- deps_cells defines what other parts get destroyed along with it
			["ROTOR"]          = { critical_damage = 2.5, args = { 419 },   --63
				deps_cells = { "BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN", "BLADE_4_IN" } }, -- 64
			["BLADE_1_IN"]     = { critical_damage = 0.5, args = { 420 } }, -- 64
			["BLADE_2_IN"]     = { critical_damage = 0.5, args = { 421 } }, -- 67
			["BLADE_3_IN"]     = { critical_damage = 0.5, args = { 422 } }, -- 70
			["BLADE_4_IN"]     = { critical_damage = 0.5, args = { 423 } }, -- 73

			["BLADE_5_IN"]     = { critical_damage = 0.5, args = { 424 } }, -- 76 Tailrotor

			["ELEVATOR_L_OUT"] = { critical_damage = 0.5, args = { 425 } }, -- 49 Tailrotor
			["STABILIZATOR_L"] = { critical_damage = 0.5, args = { 426 } }, -- 47 Tailrotor
			["STABILIZATOR_R"] = { critical_damage = 0.5, args = { 427 } }, -- 48 Tailrotor


			["WHEEL_L"] = { critical_damage = 1, args = { 430 }, deps_cells = { "AIR_BRAKE_L", "Line_STABIL_L" } }, -- 84
			["AIR_BRAKE_L"] = { critical_damage = 1, args = { 430 }},
			["Line_STABIL_L"] = { critical_damage = 1, args = { 430 } },

			["WHEEL_R"] = { critical_damage = 1, args = { 431 }, deps_cells = { "AIR_BRAKE_R", "Line_STABIL_R" } }, --85
			["AIR_BRAKE_R"] = { critical_damage = 1, args = { 431 }},
			["Line_STABIL_R"] = { critical_damage = 1, args = { 431 }},

			["FUEL_TANK_F"] = { critical_damage = 1, args = {477} }, --61

			["CABIN_BOTTOM"] = { critical_damage = 0.5, args = {472} }, --6
			["CABIN_LEFT_SIDE"] = { critical_damage = 0.5, args = {471}}, --4
			["CABIN_RIGHT_SIDE"] = { critical_damage = 0.5, args = {470}}, --5

			["ELERON_L"] = { critical_damage = 1, args = {475} }, --25
			["ELERON_R"] = { critical_damage = 1, args = {476} }, --26
			["ENGINE"] = { critical_damage = 1, args = {483} }, --11
			["FLAP_L_OUT"] = { critical_damage = 1, args = {-1} }, --31
			["FLAP_R_OUT"] = { critical_damage = 1, args = {-1} }, --32

			["FUSELAGE_LEFT_SIDE"] = { critical_damage = 1, args = {479} }, --9
			["FUSELAGE_RIGHT_SIDE"] = { critical_damage = 1, args = {480} }, --10
			["NOSE_LEFT_SIDE"] = { critical_damage = 1, args = {473} }, --1
			["NOSE_RIGHT_SIDE"] = { critical_damage = 1, args = {474} }, --2
			["LEFT_GEAR_BOX"] = { critical_damage = 1, args = {482} }, --15
			["RIGHT_GEAR_BOX"] = { critical_damage = 1, args = {481} }, --16
			["TAIL_LEFT_SIDE"] = { critical_damage = 1, args = {-1} }, --56
			["TAIL_RIGHT_SIDE"] = { critical_damage = 1, args = {-1} }, --57
			["WING_L_PART_IN"] = { critical_damage = 1, args = {-1} }, --33
			["WING_R_PART_IN"] = { critical_damage = 1, args = {-1} }, --34
			["COCKPIT_Line"] = { critical_damage = 1, args = {-1} },
			["TAIL_BOTTOM"] = { critical_damage = 1, args = {-1} }, --58

			
			["FUEL_TANK_B"] = {critical_damage = 2, args = {-1}}, -- 62
			["ENGINE_1"] = {critical_damage = 2, args = {-1}}, -- 103
			["FRONT_GEAR_BOX"] = {critical_damage = 2, args = {-1}}, -- 8
			

			["COCKPIT"] = {critical_damage = 1,args = {65}}, -- 3

			["CREW_1"] = {critical_damage = 1,deps_cells = { "COCKPIT"}},--90
			["CREW_2"] = {critical_damage = 1,deps_cells = { "COCKPIT"}},--91

		}),

	Failures = {
	},

	DamageParts = { -- parts that fall off when aircraft is hit or crashes

	},
	lights_data = {
	},


	net_animation = { --transmits draw arguments over multiplyer for others to see
		35,
		36, -- tail rotor
		37, -- main rotor
		38, --canopy
		
		201, -- skids
		202,
		203,
		204,
		207,--doors
		208,
		209,
		210,
		211,

		111, --guns
		113, --gunner visibility
		115, -- lights
		116,
		117,--rocket mounts
		118,
		119, -- floaters
		120,
		121,
		122,
		123,
		124,

		127, --flares
		450, --gun el

		1000, --door gunner orientation
		1001,
		--1100, --flap
		--1101,
		--1102,
		--1103,

		140, --cam rig
		141,
		142

	},

	--sound_name = "Rotor", -- rotor sound from Sounds/sdef

	engine_data =
	{
	-- most of these are unknown right now, but they are only for AI
		power_take_off = 1000,
		power_max = 1000,
		power_WEP = 1000,
		power_TH_k =
		{
			[1] = { 0, -230.8, 2245.6 },
			[2] = { 0, -230.8, 2245.6 },
			[3] = { 0, -325.4, 2628.9 },
			[4] = { 0, -235.6, 1931.9 },
		},
		SFC_k = { 2.045e-007, -0.0006328, 0.803 },
		power_RPM_k = { -0.08639, 0.24277, 0.84175 },
		power_RPM_min = 9.1384,
		sound_name = "External/oh6_Silent",
	},


	HumanRadio = {
		frequency = 262.0,
		editable = true,
		minFrequency = 100,
		maxFrequency = 400,
		modulation = MODULATION_AM
	},
	panelRadio =
	{
        [1] =
		{
			name = _("AN/ARC-51BX"), -- 225.000 to 399.975 MHz AM
			range =
			{
				{min = 225.0, max = 399.975}
			},
			channels =
			{
				[1] = { name = _("Channel 1"),	default = radio_presets[1]},	-- mineralnye-vody (URMM) : 264.0
				[2] = { name = _("Channel 2"),	default = radio_presets[2]},	-- nalchik (URMN) : 265.0
				[3] = { name = _("Channel 3"),	default = radio_presets[3]},	-- sochi-adler (URSS) : 256.0
				[4] = { name = _("Channel 4"),	default = radio_presets[4]},	-- maykop-khanskaya (URKH), nellis (KLSV) : 254.0
				[5] = { name = _("Channel 5"),	default = radio_presets[5]},	-- anapa (URKA) : 250.0
				[6] = { name = _("Channel 6"),	default = radio_presets[6]},	-- beslan (URMO) : 270.0
				[7] = { name = _("Channel 7"),	default = radio_presets[7]},	-- krasnodar-pashkovsky (URKK) : 257.0
				[8] = { name = _("Channel 8"),	default = radio_presets[8]},	-- sukhumi-babushara (UGSS) : 255.0
				[9] = { name = _("Channel 9"),	default = radio_presets[9]},	-- kobuleti (UG5X) : 262.0
				[10] = { name = _("Channel 10"),	default = radio_presets[10]},	-- gudauta (UG23) : 259.0
				[11] = { name = _("Channel 11"),	default = radio_presets[11]},	-- tbilisi-soganlug (UG24) : 268.0
				[12] = { name = _("Channel 12"),	default = radio_presets[12]},	-- tbilisi-vaziani (UG27) : 269.0
				[13] = { name = _("Channel 13"),	default = radio_presets[13]},	-- batumi (UGSB) : 260.0
				[14] = { name = _("Channel 14"),	default = radio_presets[14]},	-- kutaisi-kopitnari (UGKO) : 263.0
				[15] = { name = _("Channel 15"),	default = radio_presets[15]},	-- senaki-kolkhi (UGKS) :  261.0
				[16] = { name = _("Channel 16"),	default = radio_presets[16]},	-- tbilisi-lochini (UGTB) : 267.0
				[17] = { name = _("Channel 17"),	default = radio_presets[17]},	-- krasnodar-center (URKI), creech (KINS) : 251.0
				[18] = { name = _("Channel 18"),	default = radio_presets[18]},	-- krymsk (URKW), mccarran (KLAS) : 253.0
				[19] = { name = _("Channel 19"),	default = radio_presets[19]},	-- mozdok (XRMF) : 266.0
				[20] = { name = _("Channel 20"),	default = radio_presets[20]},	-- N/A, groom lake/homey (KXTA) : 252.0
			},
		},
    },
	AddPropAircraft =
	{
		{
			id = "CableCutterEnables",
			control = "checkbox",
			label = _("Cable Cutter"), 
			defValue = false,
			weightWhenOn = 0,
			arg = 150,
		},
		{
			id = "FlaresEquipped",
			control = "checkbox",
			label = _("Equip Flares"),
			defValue = false,
			weightWhenOn = 10,
			arg = 127,
		},
		{
			id = "RWREquipped",
			control = "checkbox",
			label = _("Equip RWR"),
			defValue = false,
			weightWhenOn = 10,
			arg = 31,
		},
	},
	InheriteCommonCallnames = true,
	SpecificCallnames=
	{
		["USA"] = 
		{
			{_('Assault'), 'Assault'},
			{_('Banshee'),'Banshee'},
			{_('Condor'),'Condor'},
			{'Gunner','Gunner'},
			{_('Eagle'),'Eagle'},
			{_('Griffin'),'Griffin'},
			{_('Little Griffin'),'Little Griffin'},
			{_('Deadbone'),'Deadbone'},
			{_('Brandy'),'Brandy'},
			{_('Thunder'),'Thunder'},
			{_('Roadrunner'),'Roadrunner'},
			{_('Woodstock'),'Woodstock'},
			{_('Scalphunter'),'Scalphunter'},
			{_('Darkhorse'),'Darkhorse'},
			{_('War Wagon'),'War Wagon'},
		}
	}



}

add_aircraft(OH6)
